using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/09/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database read access to patient 
	///	special instructions data. 
	///</summary>

	public class PatientSpecialInstruction
	{

		#region methods

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2682"> 
		///		<ExpectedInput>Valid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable with PatientSpecialInstruction information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2683"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>Retrieves special instructions put in for a given patient</summary>
		///<param name="patientGuid">Patient GUID</param>
		///<returns>DataTable containing special instructions for a given patient</returns>
		public static DataTable GetSpecialInstructionsForPatient(Guid patientGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetSpecialInstructionsForPatient.patientguid, System.Data.SqlDbType.UniqueIdentifier), 
				new SqlParameter(STOREDPROC.GetSpecialInstructionsForPatient.divisioncode, System.Data.SqlDbType.VarChar)
			};
			
			prms[0].Value = patientGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			return Common.StoredProcedure.GetData(STOREDPROC.GetSpecialInstructionsForPatient.StoredProcName, prms).Tables[0];
		}
		
		#endregion
	}
}